/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.insight.scan.model;

import com.sonatype.insight.scan.model.ArtifactId;
import com.sonatype.insight.scan.model.Dependency;
import com.sonatype.insight.scan.model.DirectoryScanItem;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class ProjectScanItem
extends DirectoryScanItem {
    private static final long serialVersionUID = -3245508725736845394L;
    private List<Dependency> dependencies;

    public static ProjectScanItem maven(String groupId, String artifactId, String version) {
        ArtifactId id = ArtifactId.maven(groupId, artifactId, version);
        return new ProjectScanItem(id.getKind(), id.getId());
    }

    public ProjectScanItem() {
    }

    public ProjectScanItem(String kind, String id) {
        this.setKind(kind);
        this.setId(id);
    }

    public List<Dependency> getDependencies() {
        return this.dependencies != null ? this.dependencies : Collections.emptyList();
    }

    public void addDependency(Dependency dependency) {
        if (dependency != null) {
            if (this.dependencies == null) {
                this.dependencies = new ArrayList<Dependency>();
            }
            this.dependencies.add(dependency);
        }
    }

    @Override
    public String toString() {
        return this.getPath() + ", " + this.getId();
    }
}

